/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{ Copyright (c) 2003, 2005 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.IO;
using System.Text;
using System.Collections;
using System.Collections.Specialized;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Reflection;

namespace Borland.Data.Web
{
   #region PageStateManager
   public class PageStateManager
   {
	   private const string AtSysError = " at System.";
	   private const int MaxTablesInDataSet = 999999;
	   private Page page;
	   private string fullPageName;
	   private DBWebDataSource dataSource;
	   private IDBDataSource idataSource;

	   private IDBPageStateManager dataSourceAccess;
	   // last row here means the row that was current prior to
	   // current scrolling, and does NOT mean the last row of
	   // the table.  The last row of the table is RowCount!
	   private int [] FLastRow;
	   private int [] FRowCount;
	   // Current physical row position for all tables in dataset unadjusted for
	   // deleted or inserted rows.
	   private int [] FCurrentRow;
	   private int [] FNextRowAsParent;
	   // Keep track of deleted records not sent to server for undo purposes
	   private int[][] FDeletedRows;
	   private int[][] FInsertedRows;
	   // store current row when DataSet is not yet available
	   private int FCurrentRowHolder;
	   // These contain values set with RegisterHidden Fields as
	   // well as any values from SUBMIT field on page
	   private ArrayList FErrors;
	   private ArrayList FWarnings;
	   private ArrayList FDuplicateColumns;
	   private NameValueCollection postCollectionValues;
	   private NameValueCollection tableChanges;
	   public ClientAction clientAction;
	   private int FRowChangeController;
	   private bool [] FDatasetUpdated;
	   private ArrayList FTableOrView;
	   private bool FHiddenRowsSet;
	   private bool FPostCollectionValuesSet;
	   private string FAspGridId;
	   private bool FDisallowInsert;


	   public PageStateManager(Page p, DBWebDataSource ds, string gridIdentifier)
	   {
		 page = p;
		 if( !ClassUtils.IsDesignTime(page) )
			fullPageName = ClassUtils.GetPageName(p);
		 else
		 	fullPageName = "";
         dataSource = ds;
         dataSourceAccess = ds as IDBPageStateManager;
         idataSource = (ds as IDBDataSource);
         FCurrentRow = null;
         FNextRowAsParent = null;
		 clientAction = ClientAction.ecaNone;
		 postCollectionValues = new NameValueCollection();
		 tableChanges = new NameValueCollection();
		 FCurrentRowHolder = 0;
		 FRowChangeController = MaxTablesInDataSet;
		 FErrors = new ArrayList();
		 FWarnings = new ArrayList();
		 FDuplicateColumns = new ArrayList();
		 if( !ClassUtils.IsDesignTime(page) && !ds.AutoRefresh)
			if( page.Session[fullPageName + idataSource.GetDataSourceName(page) + DBWebConst.sDataSource] == null && ds.DataSource != null )
				page.Session[fullPageName + idataSource.GetDataSourceName(page) + DBWebConst.sDataSource] = ds.DataSource;
		 FAspGridId = gridIdentifier;
		 DataSet dataSet = dataSourceAccess.DataSetFromDataSource(dataSource.DataSource);
		 FTableOrView = new ArrayList();
		 FDisallowInsert = false;
		 if( dataSet != null && dataSet.Tables != null )
         	InitDataSet(dataSet);
	   }

	   public void InitDataSet(DataSet dataSet)
	   {
			for( int i = 0; i < dataSet.Tables.Count; i++ )
			{
				FTableOrView.Add(null);
			}
	   }

	   public bool SetTableOrView( string TableName, Object o )
	   {
			int index = dataSource.IndexOfTable(TableName);
			if( index >= 0 )
				FTableOrView[index] = o;
			return index >= 0;
	   }

      public Object GetTableOrView( string TableName )
      {
      	for( int i = 0; i < FTableOrView.Count; i++ )
        	if( FTableOrView[i] != null )
            {
				if( (FTableOrView[i] is DataView) &&
                    ((FTableOrView[i] as DataView).Table.TableName == TableName ) )
                  return FTableOrView[i];
            	else if( (FTableOrView[i] is DataTable) &&
                    ((FTableOrView[i] as DataTable).TableName == TableName ) )
				  return FTableOrView[i];
				}
		   return null;
	  }

	  /* Constraints have to be turned off when inserting, as key has not been entered yet.  Also,
			AutoApply event should not be called for the same reason*/
		protected void SetInsertState(string TableName, InsertState value)
		{
			page.Session[fullPageName + TableName + DBWebConst.sInsertingRow] = value;
		}
		protected bool InsertInProgress()
		{
			for( int i = 0; i < RelatedTables.Count; i++ )
				if( GetInsertState(RelatedTables[i].ToString()) == InsertState.InsertStart)
					return true;
			return false;
		}
		public InsertState GetInsertState(string TableName)
		{
			Object insertState = page.Session[fullPageName + TableName + DBWebConst.sInsertingRow];
			if( insertState == null )
				return InsertState.InsertNone;
			else if( Convert.ToInt32(insertState) == Convert.ToInt32(InsertState.InsertStart) )
				return InsertState.InsertStart;
			else if( Convert.ToInt32(insertState) == Convert.ToInt32(InsertState.InsertEnd) )
				return InsertState.InsertEnd;
			return InsertState.InsertNone;
		}
		public bool IsInsertingRow()
		{
			if( ClassUtils.IsDesignTime(page) )
				return false;
			for( int i = 0; i < RelatedTables.Count; i++ )
				if( IsInsertingRow(RelatedTables[i].ToString()) )
					return true;
			return false;
		}

		public bool IsInsertingRow(string TableName)
		{
			if( ClassUtils.IsDesignTime(page) )
				return false;
			Object insertState = page.Session[fullPageName + TableName + DBWebConst.sInsertingRow];
			if( insertState == null )
				return false;
			return Convert.ToInt32(insertState) == Convert.ToInt32(InsertState.InsertStart);
		}

		public bool IsInsertingRow(Object ATableOrView)
		{
			string TableName;
			if( ClassUtils.IsDesignTime(page) || ATableOrView == null )
				return false;
			if( ATableOrView is DataView )
				TableName = (ATableOrView as DataView).Table.TableName;
			else
				TableName = (ATableOrView as DataTable).TableName;
			return IsInsertingRow(TableName);
		}

	  public Page GetPage()
	  {
		 return page;
	  }

	  public string GetFullPageName()
	  {
		 return fullPageName;
	  }

	  public bool CheckPage(Page p)
	  {
		return page == p;
	  }

	  public ArrayList Errors
	  {
		  get
		  {
			return FErrors;
		  }
	  }
	  public ArrayList Warnings
	  {
		get
		 {
			return FWarnings;
		 }
	  }

	  #region finding dirty records: insertions/deletions
		protected int ChangedRowCount( string TableName, int iToRow )
      {
		   return GetInsertCount(TableName, iToRow) - GetDeleteCount(TableName, iToRow);
	   }

	  protected int GetInsertCountFromArray(int tableIndex, int iToRow)
	  {
		 if( iToRow == -1 )
		 	return FInsertedRows[tableIndex].Length;
		 int iCount = 0;
		 for( int i = 0; i < FDeletedRows[tableIndex].Length; i++ )
		 {
			if(FInsertedRows[tableIndex][i] < iToRow)
				iCount++;
		 }
		 return iCount;
	  }

	  // any time we check for RowCount, we need to adjust count by
	  // the # of deletions, since the table will continue holding deleted
	  // rows.
	  public int GetInsertCount(string TableName, int iToRow)
	  {
		if( ClassUtils.IsDesignTime(page) )
			return 0;
		if( FInsertedRows == null )
			SetupCurrentRow();
		int index = dataSource.IndexOfTable(TableName);
		if( FInsertedRows[index] == null )
			return 0;
		if( !dataSourceAccess.IsDetailTable(TableName) )
			return GetInsertCountFromArray(index, iToRow);
		else
			return dataSourceAccess.GetInsertCountFromSession(page, TableName, iToRow);
	  }

      public bool GetPageFieldsWritten()
      {
      	bool bWritten = false;
         bWritten = FHiddenRowsSet;
         FHiddenRowsSet = true;
         return bWritten;
      }

      public bool GetDatasetUpdated(string TableName)
      {
         int index = dataSource.IndexOfTable(TableName);
         if( index >= 0 )
      		return DatasetUpdated[index];
         return false;
		}

		public NameValueCollection PostCollectionValues
		{
			get
			{
				return postCollectionValues;
			}
		}

      public bool GetPostCollectionValuesSet()
      {
         bool value = FPostCollectionValuesSet;
         FPostCollectionValuesSet = true;
         return value;
      }

		public void ClearUpdated()
		{
			for( int i = 0; i < DatasetUpdated.Length; i ++ )
				DatasetUpdated[i] = false;
		}

		public void SetDatasetUpdated(string TableName, bool value)
      {
         int index = dataSource.IndexOfTable(TableName);
         if( index >= 0 )
      		DatasetUpdated[index] = value;
      }

	  protected int AddDeletedToRowCount( string TableName, int iToRow )
	  {
		 int iStart = 0;
		 int iTotal = iToRow;
                 //Fix for 213236
		 int iRowCount = GetRowCount(TableName);
		 for( int i = 0; i < iRowCount -1; i++ )
		 {
			if( !IsRowDeleted(TableName, i) )
				iStart++;
			else
			   iTotal++;
			if( iStart > iToRow )
				break;
		 }
		 return iTotal;
	  }

		protected int GetDeleteCountFromArray( int tableIndex, int iToRow )
		{
			int iCount = 0;
			if( iToRow == -1 )
				return FDeletedRows[tableIndex].Length;
			for( int i = 0; i < FDeletedRows[tableIndex].Length; i++ )
			{
				if(FDeletedRows[tableIndex][i] < iToRow)
					iCount++;
			}
			return iCount;
		}

		// if iRow == -1, get count of all deleted rows
		// if iRow == valid row, only get count of deleted
		//     rows prior to iRow
		public int GetDeleteCount( string TableName, int iToRow )
		{
		int iCount = 0;
		 if( ClassUtils.IsDesignTime(page) )
			return iCount;
		 int index = dataSource.IndexOfTable(TableName);
		 if( FDeletedRows[index] == null )
			return iCount;
		 if( !dataSourceAccess.IsDetailTable(TableName) )
			return GetDeleteCountFromArray(index, iToRow);
		 else
			return dataSourceAccess.GetDeleteCountFromSession(page, TableName, iToRow);
		}
	  #endregion finding dirty records: insertions/deletions

	  #region row state access functions

		public void SetCurrentObject(Object tableOrView, string DataMember)
		{
			int iRow = getCurrentRow(DataMember);
			Object o = null;
			if( iRow >= 0 && iRow < GetRowCount(DataMember) )
				o = dataSource.GetRowValues(tableOrView, iRow, true);
			page.Session[fullPageName + DataMember + "_CurrentObj"] = o;
		}
		public object GetCurrentObject(string DataMember)
		{
			if( ClassUtils.IsDesignTime(page) )
				return null;
			return page.Session[fullPageName + DataMember + "_CurrentObj"];
		}
		public int [] CurrentRow
      {
      	get
         {
         	if( FCurrentRow == null )
            	SetupCurrentRow();
			   return FCurrentRow;
		 }
	  }

	  public int [] RowCount
	  {
		get
		 {
			if( FRowCount == null )
				SetupCurrentRow();
			return FRowCount;
		 }
	  }

	  public int [] GetDeleteRows(string TableName)
	  {
		if( FDeletedRows == null )
			SetupCurrentRow();
		 int index = dataSource.IndexOfTable(TableName);
		 return FDeletedRows[index];
	  }

	  public bool IsRowDeleted(string TableName, int iRow)
	  {
		string Key = ClassUtils.GenKeyName(fullPageName, DBWebConst.sDbxDelta, TableName, iRow, 0, null, RegularizeParentRows(TableName)) + DBWebConst.sDbxDelete;
		return page.Session[Key] != null;
	  }

	  public bool IsRowInserted(string TableName, int iRow)
	  {
		string Key = ClassUtils.GenKeyName(fullPageName, DBWebConst.sDbxDelta, TableName, iRow, 0, null, RegularizeParentRows(TableName)) + DBWebConst.sDbxInsert;
		return page.Session[Key] != null;
	  }

	  protected void AddDeletedRow(string TableName, int value)
	  {
		if( FDeletedRows == null )
			SetupCurrentRow();
		 int index = dataSource.IndexOfTable(TableName);
         if( FDeletedRows[index] == null )
         {
         	FDeletedRows[index] = new int[1];
            FDeletedRows[index][0] = value;
         }
         else
         {
         	int [] temp = new int [FDeletedRows[index].Length + 1];
            for( int i = 0; i < FDeletedRows[index].Length; i++ )
            	temp[i] = FDeletedRows[index][i];
            temp[FDeletedRows[index].Length] = value;
            FDeletedRows[index] = temp;
         }
      }

      protected void AddInsertedRow(string TableName, int value)
      {
      	if( FInsertedRows == null )
         	SetupCurrentRow();
         int index = dataSource.IndexOfTable(TableName);
         if( FInsertedRows[index] == null )
         {
         	FInsertedRows[index] = new int[1];
            FInsertedRows[index][0] = value;
         }
         else
         {
         	int [] temp = new int [FInsertedRows[index].Length + 1];
            for( int i = 0; i < FInsertedRows[index].Length; i++ )
            	temp[i] = FInsertedRows[index][i];
            temp[FInsertedRows[index].Length] = value;
            FInsertedRows[index] = temp;
         }
      }

      protected void RemoveDelRow( int index, int iRemove )
      {
      	if( FDeletedRows == null )
         	SetupCurrentRow();
      	int [] temp = new int [FDeletedRows[index].Length - 1];
         int iSkip = 0;
         for( int i = 0; i < FDeletedRows[index].Length; i++ )
         {
         	if( i != iRemove )
            	temp[i - iSkip] = FDeletedRows[index][i];
            else
               iSkip = 1;
         }
         FDeletedRows[index] = temp;
      }

      protected void RemoveInsRow( int index, int iRemove )
      {
      	if( FInsertedRows == null )
         	SetupCurrentRow();
      	int [] temp = new int [FInsertedRows[index].Length - 1];
         int iSkip = 0;
         for( int i = 0; i < FInsertedRows[index].Length; i++ )
         {
         	if( i != iRemove )
            	temp[i - iSkip] = FInsertedRows[index][i];
            else
               iSkip = 1;
         }
         FInsertedRows[index] = temp;
      }

      protected void RemoveDeletedRow( string TableName, int iRow )
      {
      	if( FDeletedRows == null )
         	return;
         int index = dataSource.IndexOfTable(TableName);
         if( FDeletedRows[index] == null )
           	return;
         for( int i = 0; i < FDeletedRows[index].Length; i++ )
         {
         	if(FDeletedRows[index][i] == iRow)
            	RemoveDelRow(index, i);
         }
      }

	  protected void RemoveInsertedRow( string TableName, int iRow )
	  {
		if( FInsertedRows == null )
			return;
		 int index = dataSource.IndexOfTable(TableName);
		 if( FInsertedRows[index] == null )
			return;
		 for( int i = 0; i < FInsertedRows[index].Length; i++ )
		 {
			if(FInsertedRows[index][i] == iRow)
			{
				RemoveInsRow(index, i);
			   break;
            }
         }
      }

      public void RemoveDeletedRows( string TableName)
      {
      	if( FDeletedRows == null )
         	return;
         int index = dataSource.IndexOfTable(TableName);
         if( FDeletedRows[index] == null )
           	return;
         FDeletedRows[index] = null;
      }

      public void RemoveInsertedRows( string TableName)
	  {
		if( FInsertedRows == null )
			return;
         int index = dataSource.IndexOfTable(TableName);
         if( FInsertedRows[index] == null )
           	return;
         FInsertedRows[index] = null;
      }
      // last row here means the row that was current prior to
      // scrolling, and does NOT mean the last row of
      // the table.  The last row of the table is RowCount
      protected int [] LastRow
      {
      	get
         {
         	if( FLastRow == null )
            	SetupCurrentRow();
            return FLastRow;
         }
      }

      private void GetDeletedAndInsertedRowsForTable(string TableName)
      {
      	if( ClassUtils.IsDesignTime(page ) )
            return;
		 for( int i = 0; i < page.Session.Count; i++ )
		 {
			string sKey = page.Session.Keys[i];
			if( (sKey.StartsWith( DBWebConst.sDbxDelta + fullPageName) && sKey.IndexOf( DBWebConst.sDbxDelete ) > 0) ||
				(sKey.StartsWith( DBWebConst.sDbxDelta + fullPageName) && sKey.IndexOf( DBWebConst.sDbxInsert ) > 0 ) )
			{
			   string tableName;
			   int iRow;
			   int iCol;
			   string oldValue;
			   ClassUtils.GetRowColFromKey(sKey, fullPageName, out tableName, out iRow, out iCol, out oldValue);
			   if( tableName == TableName )
			   {
				  if( sKey.IndexOf( DBWebConst.sDbxDelete ) > 0 )
					AddDeletedRow(TableName, iRow);
				  else
					AddInsertedRow(TableName, iRow);
			   }
			}
		 }
	  }

	  protected void SetupCurrentRow()
	  {
		 DataSet dataSet = dataSourceAccess.DataSetFromDataSource(dataSource.DataSource);
		 if( dataSet != null && dataSet.Tables.Count > 0 )
		 {
			FCurrentRow = new int[dataSet.Tables.Count];
			FRowCount = new int[dataSet.Tables.Count];
			FNextRowAsParent = new int[dataSet.Tables.Count];
			FLastRow = new int[dataSet.Tables.Count];
			FDeletedRows = new int[dataSet.Tables.Count] [];
			FInsertedRows = new int[dataSet.Tables.Count] [];
			for( int i = 0; i < FCurrentRow.Length; i++ )
			{
				FNextRowAsParent[i] = -1;
				if( ClassUtils.IsDesignTime(page) || (page.Session[fullPageName + dataSet.Tables[i].TableName + DBWebConst.sCurrentRowIndex] == null) )
					FCurrentRow[i] = 0;
				else
					FCurrentRow[i] = Convert.ToInt32(page.Session[fullPageName + dataSet.Tables[i].TableName + DBWebConst.sCurrentRowIndex]);
				FLastRow[i] = 0;
				FDeletedRows[i] = null;
				FInsertedRows[i] = null;
				GetDeletedAndInsertedRowsForTable(dataSet.Tables[i].TableName);
				if( !ClassUtils.IsDesignTime(page) && page.Session[fullPageName + dataSet.Tables[i].TableName + DBWebConst.sRowCount] != null )
					FRowCount[i] = Convert.ToInt32(page.Session[fullPageName + dataSet.Tables[i].TableName + DBWebConst.sRowCount]);
				else if( (dataSource.DataSource is DataView) &&
						((dataSource.DataSource as DataView).Table.TableName == dataSet.Tables[i].TableName) )
					FRowCount[i] = (dataSource.DataSource as DataView).Count;
				else if( dataSourceAccess.IsDetailTable( dataSet.Tables[i].TableName ) )
					FRowCount[i] = GetChildRowCount( dataSet.Tables[i].TableName )
									+ GetInsertCount(dataSet.Tables[i].TableName, -1);
				else
					FRowCount[i] = dataSet.Tables[i].Rows.Count
								 	+ GetInsertCount(dataSet.Tables[i].TableName, -1);
			}
		 }
      }

		protected ArrayList RelatedTables
      {
      	get
         {
            return dataSource.RelatedTables;
         }
      }

      protected bool [] DatasetUpdated
      {
      	 get
         {
	      	if( FDatasetUpdated == null && dataSource.RelatedTables != null )
   	        {
      	   		FDatasetUpdated = new bool[dataSource.RelatedTables.Count];
         	   		for( int i = 0; i < FDatasetUpdated.Length; i++ )
            			FDatasetUpdated[i] = false;
	         }
	         return FDatasetUpdated;
         }
      }

      public int GetRowCount(string TableName)
      {
      	for( int i = 0; i < RelatedTables.Count; i++ )
        	   if( TableName == RelatedTables[i].ToString() )
            	return RowCount[i];
        return -1;
      }

      public void SetRowCount(string TableName, int value)
      {
      	for( int i = 0; i < RelatedTables.Count; i++ )
		if( TableName == RelatedTables[i].ToString() )
		{
			if( value < 0 )
				value = 0;
			RowCount[i] = value;
			if( !ClassUtils.IsDesignTime(page) )
				page.Session[fullPageName + TableName + DBWebConst.sRowCount] = value;
			break;
		}
      }

    	public int GetParentRowForChild(string TableName)
      {
         return getCurrentRow(TableName);
      }

    	public int getCurrentRow(string TableName)
      {
         int iCurrentRow = -1;
      	for( int i = 0; i < RelatedTables.Count; i++ )
         	if( RelatedTables[i].ToString() == TableName )
            {
            	iCurrentRow = CurrentRow[i];
               break;
            }
      	return iCurrentRow;
      }

    	public int getFirstParentRow(string TableName)
      {  // if using Session, find the FirstParent for Tablename
         // otherwise, find the current row for TableName's first parent.
         // -- Changed: don't use session;
      	int iParentRow = -1;
         string parentTable = dataSourceAccess.FirstParent(TableName);
         iParentRow = getCurrentRow(parentTable);
         return iParentRow;
      }

      // last row here means the row that was current prior to
      // current scrolling, and does NOT mean the last row of
      // the table.  The last row of the table is RowCount!
    	public int getLastRow(string TableName)
      {
      	for( int i = 0; i < RelatedTables.Count; i++ )
         	if( RelatedTables[i].ToString() == TableName )
            	return LastRow[i];
      	return -1;
      }

      public void setCurrentRow(string TableName, int value)
      {
      	for( int i = 0; i < RelatedTables.Count; i++ )
         	if( RelatedTables[i].ToString() == TableName )
            {
	            	CurrentRow[i] = value;
               if( !ClassUtils.IsDesignTime(page) )
               	page.Session[fullPageName + TableName + DBWebConst.sCurrentRowIndex] = value;
               break;
            }
      }

	  public void setLastRow(string TableName, int value)
      {
      	for( int i = 0; i < RelatedTables.Count; i++ )
         	if( RelatedTables[i].ToString() == TableName )
            {
            	LastRow[i] = value;
               break;
            }
      }

      public void incCurrentRow(string TableName)
      {
      	for( int i = 0; i < RelatedTables.Count; i++ )
         	if( RelatedTables[i].ToString() == TableName )
            {
            	CurrentRow[i]++;
               break;
            }
      }

      public void decCurrentRow(string TableName)
      {
      	for( int i = 0; i < RelatedTables.Count; i++ )
         {
         	if( RelatedTables[i].ToString() == TableName )
            {
            	CurrentRow[i]--;
               break;
            }
         }
      }
	  #endregion row state access functions

	  #region child row management

	  protected int CalcRowCount( string TableName )
	  {
		 Object table = dataSourceAccess.GetTableOrView(page, TableName, true, false, false);
		 if( table != null )
		 {
			if( table is DataTable )
				return (table as DataTable).Rows.Count;
			else if (table is DataView)
				return (table as DataView).Count;
		 }
		 return -1;
	  }

	  protected int GetChildRowCount(string TableName)
	  {
			int iRows = CalcRowCount(TableName);
			if( dataSourceAccess.UsesHardDeletes(page, TableName) )
				iRows += GetDeleteCount(TableName, -1);
			return iRows;
	  }

	  // if Parent row is moved, Currentrow all detilas for need to be set back to 0,
	  // and detail RowCount needs to be adjusted based on # of rows in view.
	  protected void AdjustChildCurrentRow(string TableName, bool bNewRow)
	  {
		 DataRelation relation = dataSourceAccess.GetRelation(page, TableName, "");
		 while( relation != null )
		 {
			DataTable table = relation.ChildTable;
			page.Session[fullPageName + table.TableName + DBWebConst.sLastRow] = getCurrentRow( table.TableName );
			if( bNewRow )
			{
				setCurrentRow(table.TableName, -1);
				SetRowCount(table.TableName, 0);
			}
			else
			{
				DataView view = (dataSourceAccess.GetTableOrView(page, table.TableName, true, false, false) as DataView);
				if( view != null )
					SetRowCount(table.TableName, view.Count);
				if( view.Count < 0 )
					setCurrentRow(table.TableName, -1);
				else if( dataSourceAccess.UsesHardDeletes(page, table.TableName) )
					setCurrentRow(table.TableName, 0);
				else
					ResetCurrentRow( 0, table.TableName, 1 );
			}
			RemoveAggKeyForColumn(TableName, "");
			relation = dataSourceAccess.GetRelation(page, table.TableName, "");
		 }
	  }
	  #endregion child row management

	  #region application statemanagement

	  // iRow is the new row, but if its past eof, before bof, or
	  // 					on a deleted row, we need to adjust it.
	  // iDirection will be +1 or -1, depending if you want to go forward or backward
	  // 				in the table
	  public void ResetCurrentRow(int iRow, string TableName, int iDirection)
	  {
		 bool IsDetailTable = dataSourceAccess.IsDetailTable(TableName);
		 bool UsesHardDelete = dataSourceAccess.UsesHardDeletes(page, TableName);
		 int iRowCount = GetRowCount(TableName);
		 if( iRowCount - GetDeleteCount(TableName, -1) <= 0 )
		 {
			if( !IsDetailTable || !UsesHardDelete || iRowCount == 0 )
			{
				setCurrentRow(TableName, -1);
				return;
			}
		 }
		if( iRow >= iRowCount )
			iRow = 0;
		 else if( iRow < 0 )
			iRow = iRowCount -1;
		 bool bThroughTable = false;
		 while(iRow >= 0 && IsRowDeleted(TableName, iRow) )
		 {
			iRow += iDirection;
			if( (iRow >= iRowCount) || (iRow < 0) )
			{
				if( bThroughTable )
					iRow = -1;  // there is no current row: set to -1 and exit loop
				else
				{
					if( iRow < 0 )
						iRow = iRowCount -1;
					else
						iRow = 0;
					bThroughTable = true;
				}
			}
		 }
		 setCurrentRow(TableName, iRow);
	  }

	  private string FindInsertKeyToRemove(string TableName, int iRow)
	  {
		string sInsKey = ClassUtils.GetStartKeyName(DBWebConst.sDbxDelta, fullPageName + TableName, Convert.ToString(iRow), 0);
		for( int i = 0; i < page.Session.Count; i++ )
		 {
			string sKey = page.Session.Keys[i];
			if( sKey.StartsWith(sInsKey) && sKey.IndexOf(DBWebConst.sDbxInsert) > 0 )
				return sKey;
		 }
		 return null;
      }

      // if an inserted Row has been removed from the stack of changes due to the
	  // fact that is was null and deleted from the dataset, it is necessary
      // to adjust the iRow of all changes made to rows greater than the inserted
      // row which has been deleted.
      protected void AdjustDeltaRows(string TableName, int iRow)
   	{
      	string tableName;
			ArrayList removeList = new ArrayList();
         int row;
         int col;
         string oldValue;
		 int iSessionCount = page.Session.Count;
		 NameValueCollection nvc = new NameValueCollection();
		 string sKey, sValue, sNewKey;
		 // to maintain order, store off all delta's into a NameValueCollection,
		 // decrementing the row for any rows > iRow (the deleted row)
		 for( int i = 0; i < iSessionCount; i++ )
		 {
			sKey = page.Session.Keys[i];
			if( sKey.StartsWith(DBWebConst.sDbxDelta + fullPageName) )
			{
			   sValue = page.Session[i].ToString();
			   ArrayList parentRows = ClassUtils.GetRowColFromKey(sKey, fullPageName, out tableName, out row, out col, out oldValue);
			   if( tableName == TableName && row > iRow )
			   {
					  removeList.Add(sKey);
					  sNewKey = ClassUtils.GenKeyName(fullPageName, DBWebConst.sDbxDelta, TableName, row-1, col, oldValue, parentRows);
					  nvc.Add(sNewKey, sValue);
				  if( sKey.IndexOf(DBWebConst.sDbxDelete) > 0 )
				  {
					 RemoveDeletedRow(TableName, iRow);
					 AddDeletedRow(TableName, iRow -1);
				  }
				  else if( sKey.IndexOf(DBWebConst.sDbxInsert) > 0 )
				  {
					 RemoveInsertedRow(TableName, iRow);
					 AddInsertedRow(TableName, iRow -1);
				  }
			   }
			   else if( tableName != TableName || row != iRow )
			   {  // when master table is DataView, deleting a row causes hard delete
					removeList.Add(sKey);   // even when that row has data, so ...
					nvc.Add(sKey, sValue);
			   }
			   else  // ... remove updates for that row
					removeList.Add(sKey);
			}
		 }
		 for( int i = 0; i < removeList.Count; i++ )
			page.Session.Remove(removeList[i].ToString());
		 // restore ordered NameValueCollection;
		 for( int i = 0; i < nvc.Count; i++ )
			page.Session.Add(nvc.Keys[i], nvc[i]);
      }

      protected void UpdateForRemovedKey(Page page, string TableName, int iRow)
      {

		string sInsKey = FindInsertKeyToRemove(TableName, iRow);
		if( sInsKey != null )
		{
			RemoveInsert(sInsKey, TableName, iRow);
			AdjustDeltaRows(TableName, iRow);
		}
		if( iRow > 0 )
			ResetCurrentRow(iRow -1, TableName, -1);
		else
			ResetCurrentRow(iRow + 1, TableName, 1);
	  }

	  protected ArrayList RegularizeParentRows(string TableName)
	  { // ensure that all Deleted and Inserted Rows have same Key value
		// for same parent row.
		ArrayList parentRows = new ArrayList();
		int index = dataSource.IndexOfTable(TableName);
		for( int i = 0; i < CurrentRow.Length; i++ )
		{
			if( i == index )
				parentRows.Add(0);
			else
				parentRows.Add(CurrentRow[i]);
		}
		return parentRows;
	  }

		protected bool IsRowInvalid(string TableName)
		{
			bool invalidRow = false;
			object o = page.Session[DBWebConst.sInvalidRow + fullPageName + TableName];
			if( o != null )
			{
				invalidRow = true;
				page.Session.Remove(DBWebConst.sInvalidRow + fullPageName + TableName);
			}
			return invalidRow;
		}

		protected void UpdateApplicationStateForDelete(int iRow, string TableName)
		{
			if( IsRowInvalid(TableName) )
				return;
			string sKey = ClassUtils.GenKeyName(fullPageName, DBWebConst.sDbxDelta, TableName, iRow, 0, null, RegularizeParentRows(TableName)) + DBWebConst.sDbxDelete;
			page.Session[sKey] = true;
			AddDeletedRow(TableName, iRow);
			SetDatasetUpdated(TableName, false);
			int iRowCount = GetRowCount(TableName) - GetDeleteCount(TableName, -1);
			if( iRowCount <= 0 )
			{
				setCurrentRow(TableName, -1);
			}
			else
			{
				if( iRow > 0 && !IsRowDeleted(TableName, iRow-1) )
					ResetCurrentRow(iRow, TableName, -1);
				else
					ResetCurrentRow(iRow, TableName, 1);
			}
			setLastRow(TableName, -1);
			AdjustChildCurrentRow(TableName, false);
			RemoveAggKeyForColumn(TableName, "");
			page.Session[DBWebConst.sLastKeyAdded + fullPageName] = sKey;
		}

	  private void RemoveInsert(string sKey, string TableName, int iRow)
	  {
		 RemoveInsertedRow(TableName, iRow);
		 page.Session.Remove(sKey);
		 SetRowCount(TableName, GetRowCount(TableName) - 1);
	  }

	  private DataRow RowFromObject(object tableOrView, int iRow)
      {
         if( tableOrView is DataTable )
         {
			if( iRow < (tableOrView as DataTable).Rows.Count )
	         	return (tableOrView as DataTable).Rows[iRow];
         }
         else if( tableOrView is DataView )
         	if( iRow < (tableOrView as DataView).Count )
            	return (tableOrView as DataView)[iRow].Row;
         return null;
      }

	  private void RemoveDelete( string sKey, string TableName, int iRow)
	  {
		 RemoveDeletedRow(TableName, iRow);
		 page.Session.Remove(sKey);
	  }

		protected void UpdateApplicationStateForInsert(int iRow, string TableName)
		{
			string sKey = ClassUtils.GenKeyName(fullPageName, DBWebConst.sDbxDelta, TableName, iRow, 0, null, RegularizeParentRows(TableName)) + DBWebConst.sDbxInsert;
			AddInsertedRow(TableName, iRow);
			page.Session[sKey] = true;
			SetDatasetUpdated(TableName, false);
			SetRowCount(TableName, iRow + 1);
			ResetCurrentRow(iRow, TableName, -1);
			page.Session[DBWebConst.sLastKeyAdded + fullPageName] = sKey;
		}

      protected DataColumn ColumnFromColumnName(object table, int iColumn)
      {
         if( table is DataTable )
         	return (table as DataTable).Columns[iColumn];
         else if (table is DataView)
         	return (table as DataView).Table.Columns[iColumn];
         return null;
      }

      protected bool IsKeyColumn(DataColumn column)
      {
         DataRelation relation = dataSourceAccess.GetRelation(page, "", column.Table.TableName);
		 if( relation != null )
		 {
			for( int i = 0; i < relation.ChildColumns.Length; i++ )
				if( relation.ChildColumns[i].ColumnName == column.ColumnName )
				return true;
		 }
		 relation = dataSourceAccess.GetRelation(page, column.Table.TableName, "");
		 if( relation != null )
		 {
			for( int i = 0; i < relation.ParentColumns.Length; i++ )
				if( relation.ParentColumns[i].ColumnName == column.ColumnName )
				return true;
		 }
		 return false;
	  }

	  protected bool IsParentColumn(DataColumn column, string TableName)
	  {
		DataColumn[] parentColumns;
		DataColumn[] childColumns;
		dataSourceAccess.GetConstraintColumnsForParent(TableName, out parentColumns, out childColumns);
		if( parentColumns != null )
		{
			for( int i = 0; i < parentColumns.Length; i++ )
				if( parentColumns[i].ColumnName == column.ColumnName )
					return true;
		}
		return false;
	  }

		protected bool HasDetailRecords(string TableName, int iRow)
		{
			bool bHasDetails = false;
			int iCurrentRow = getCurrentRow(TableName);
			setCurrentRow(TableName, iRow);
			try
			{
				bHasDetails = idataSource.HasDetailRecords(page, TableName);
			}
			finally
			{
				setCurrentRow(TableName, iCurrentRow);
			}
			return bHasDetails;
		}

		protected void UpdateApplicationStateForUndo(string TableName)
		{
			if( clientAction == ClientAction.ecaUndoAll && !dataSourceAccess.IsDetailTable(TableName) )
			{
				dataSourceAccess.ClearSessionChanges(page);
				idataSource.DeleteUserXmlFile(page);
				page.Session[DBWebConst.sLastKeyAdded + fullPageName] = null;
				for( int i = 0; i < RelatedTables.Count; i++)
				{
					RemoveAggKeyForColumn(RelatedTables[i].ToString(), "");
					SetDatasetUpdated(RelatedTables[i].ToString(), false);
				}
				return;
			}
			bool bKeyRemoved = false;
			Object table = dataSourceAccess.GetTableOrView(page, TableName, false, false, false);
			ArrayList parentRows = null;
			for(int i = page.Session.Count - 1; i >= 0; i--)
			{
				if( ( page.Session.Count > i) &&
					( page.Session.Keys[i].StartsWith(DBWebConst.sDbxDelta + fullPageName) ) )
				{
					int iCol;
					int iRow;
					string sKey = page.Session.Keys[i];
					string tableName = null;
					string oldValue;
					parentRows = ClassUtils.GetRowColFromKey(sKey, fullPageName, out tableName, out iRow, out iCol, out oldValue);
					if( tableName == TableName ) // && dataSource.SameParentRow(page, TableName, parentRows) )
					{
						if( sKey.IndexOf(DBWebConst.sDbxDelete) > 0 )
						{
							RemoveDelete(sKey, TableName, iRow);
							RemoveAggKeyForColumn(TableName, "");
						}
						else if( sKey.IndexOf(DBWebConst.sDbxInsert) > 0 )
						{
							if( HasDetailRecords(TableName, iRow ) )
							{
								LogWarning(BdwResources.GetString("CantUndoParentInsert") );
								break;
							}
							RemoveInsert(sKey, TableName, iRow);
                     		RemoveAggKeyForColumn(TableName, "");
						}
						else  // undoing column update
						{
							DataColumn column = ColumnFromColumnName(table, iCol);
							if( IsParentColumn(column, TableName) && HasDetailRecords(TableName, iRow ) )
							{
								LogWarning(BdwResources.GetString("CantUndoParentInsert") );
								break;
							}
							page.Session.Remove( sKey );
							RemoveAggKeyForColumn(TableName, column.ColumnName);
							if(clientAction == ClientAction.ecaUndo)
							{
								if( ClassUtils.IsEmpty(oldValue) && IsRowInserted(TableName, iRow) && dataSource.IsKeyColumn(table, iCol) )
								{
									page.Session[fullPageName + TableName + DBWebConst.sInsertingRow] = InsertState.InsertStart;
									bKeyRemoved = true;
								}
							}
						}
						if((clientAction == ClientAction.ecaUndo) && sKey.IndexOf(DBWebConst.sDbxInsert) < 1 )
						{
							//* when undoing a column change, set focus back to that row
							ResetCurrentRow(iRow, TableName, -1);
						}
						else if( sKey.IndexOf(DBWebConst.sDbxInsert) > 1 && iRow == getCurrentRow(TableName) )
						{ //* if focus is now on inserted row which you are undoing, move off it
							if( iRow > 0 )
								ResetCurrentRow(iRow -1, TableName, 1);
							else
								ResetCurrentRow(iRow +1, TableName, 1);
							setLastRow(TableName, -1);
						}
						SetDatasetUpdated(TableName, false);
						if(clientAction == ClientAction.ecaUndo)
							break;
						if( bKeyRemoved )
							clientAction = ClientAction.ecaInsert;
						page.Session[DBWebConst.sLastKeyAdded + fullPageName] = null;
					}
				}
			}
			dataSourceAccess.RemoveLastChange(page);
			if(clientAction == ClientAction.ecaUndoAll)
				ResetCurrentRow(0, TableName, 1);
			else if( getCurrentRow(TableName ) < 0 && GetRowCount(TableName) > 0 )
				setCurrentRow(TableName, 0 );
			SetDatasetUpdated(TableName, false);
			AdjustChildCurrentRow(TableName, false);
		}


		protected void SaveCurrentRows(ArrayList currentRows)
		{
			string tableName;
			for( int i = 0; i < RelatedTables.Count; i++ )
			{
				tableName = Convert.ToString(RelatedTables[i]);
				currentRows.Add(getCurrentRow(tableName));
				setCurrentRow(tableName, getLastRow(tableName));
			}
		}

		protected void RestoreCurrentRows(ArrayList currentRows)
		{
			string tableName;
			for( int i = 0; i < RelatedTables.Count; i++ )
			{
				tableName = Convert.ToString(RelatedTables[i]);
				setCurrentRow(tableName, Convert.ToInt32(currentRows[i]));
				SetDatasetUpdated(tableName, false);
			}
		}

      protected DataTable TableFromObject(object o)
      {
         if( o is DataView )
            return (o as DataView).Table;
         return o as DataTable;
	  }

	  // first update the Session manager for Insert or Delete
	  // 		button hit.
		// then call ForceUpdate to update the Session manager
	  // 		for changes made in row values.
		public void UpdateApplicationState(string TableName, int ParentRow)
		{
			// if updating a detail table, we need to create it using the Parent
			// row controlling the detail rows on the last form.  This may not
			// be the current parent row, as it might have already scrolled.
			if( IsRowInvalid(TableName) )
				return;
			Object table = null;
			bool bSetForeignKeyReadOnly = GetInsertState(TableName) != InsertState.InsertEnd;
			string ParentTableName = dataSourceAccess.ParentTableNameForChildTable(TableName);
			string firstParent = ParentTableName;
			while( ParentTableName != null )
			{
				firstParent = ParentTableName;
				ParentTableName = dataSourceAccess.ParentTableNameForChildTable(firstParent);
			}
			if( firstParent == null || ParentRow == -1 )
			{
				table = dataSourceAccess.GetTableOrView(page, TableName, true, true, bSetForeignKeyReadOnly);
				ForceUpdate(table, TableName);
			}
			else
			{
				ArrayList currentRows = new ArrayList( );
				SaveCurrentRows(currentRows);
				try
				{
					table = dataSourceAccess.GetTableOrView(page, TableName, true, true, bSetForeignKeyReadOnly);
					if( table != null )
						ForceUpdate(table, TableName);
				}
				finally
				{
					RestoreCurrentRows(currentRows);
				}
			}
		}

	  public bool HasDelta()
	  {
		for( int i = 0; i < RelatedTables.Count; i++ )
			if( HasDelta( RelatedTables[i].ToString() ) )
				return true;
		return false;
	  }

	  public bool HasDelta(string TableName)
	  {
      	  if( !ClassUtils.IsDesignTime(page) )
             return idataSource.HasDelta(page, TableName);
		  return false;
	  }
	  #endregion application state management

		#region Aggregates
		protected void RegisterAggKey(string AggKey)
		{
			int iAggKeyCount = 0;
			string Key;
			for( int i = 0; i < page.Session.Count; i++ )
			{
				Key = page.Session.Keys[i];;
				if( Key.StartsWith(DBWebConst.sAggKey + fullPageName) )
					iAggKeyCount++;
			}
			Key = DBWebConst.sAggKey + fullPageName + Convert.ToString(iAggKeyCount);
			// If a key has been removed and a new one added, then
			// gaps will occur.  Adjust for this here.
			while( page.Session[Key] != null )
			{
				iAggKeyCount++;
				Key = DBWebConst.sAggKey + fullPageName + Convert.ToString(iAggKeyCount);
			}
			page.Session.Add(Key, AggKey);
		}

		protected void RemoveAggKeyForColumn(string TableName, string ColumnName)
		{
			string AggKey;
			string Key;
			for( int i = page.Session.Count -1; i >= 0; i--)
			{
				Key = page.Session.Keys[i];;
				if( Key.StartsWith(DBWebConst.sAggKey + fullPageName) )
				{
					AggKey = Convert.ToString(page.Session[Key]);
					if( (AggKey.IndexOf(DBWebConst.sAggregates +
						  TableName + DBWebConst.Splitter + ColumnName) >= 0) ||
						  (ClassUtils.IsEmpty(ColumnName) ) )
					{
						page.Session.Remove(AggKey);
						page.Session.Remove(Key);
					}
				}
         }
      }

      protected double UpdateAggregateTotal(string TableName, string ColumnName, bool getAvg, bool ignoreNullValues)
      {
		   Object table = dataSourceAccess.GetTableOrView(page, TableName, true, false, false);
         double dSum = 0;
         Object o = null;
			int nullCount = 0;
			int iCount = GetRowCount(TableName) - GetDeleteCount(TableName, -1);
			for( int i = 0; i < iCount; i++ )
         {
				if( ClassUtils.IsDesignTime(page) || (!IsRowDeleted(TableName, i)) )
            {
               if( table is DataTable )
                  o = (table as DataTable).Rows[i][ColumnName];
               else
                  o = (table as DataView)[i].Row[ColumnName];
               if( o != null && !(o is System.DBNull) )
                  dSum += Convert.ToDouble(o);
               else
                  nullCount++;
            }
         }
         if( getAvg )
         {
            if( ignoreNullValues )
            {
               if( (iCount - nullCount) > 0 )
				  dSum = dSum / (iCount - nullCount);
            }
            else
            {
               if( iCount > 0 )
                  dSum = dSum / iCount;
            }
         }
         return dSum;
      }

      protected int ObjectCompare(Object o1, Object o2, DataColumn column)
      {
         int iCompare = 0;
         if( o1 == null )
         {
				if( o2 != null )
               iCompare = -1;
         }
         else if( o2 == null )
         {
			if( o1 != null )
               iCompare = 1;
         }
		 else
         {
				if( column.DataType == Type.GetType(TypeLiterals.SystemString) )
						iCompare = o1.ToString().CompareTo(o2.ToString());
				else if(column.DataType == Type.GetType(TypeLiterals.SystemDouble) )
						iCompare = Convert.ToDouble(o1).CompareTo(Convert.ToDouble(o2));
				else if(column.DataType == Type.GetType(TypeLiterals.SystemInt32))
						iCompare = Convert.ToInt32(o1).CompareTo(Convert.ToInt32(o2));
				else if(column.DataType == Type.GetType(TypeLiterals.SystemInt16))
						iCompare = Convert.ToInt16(o1).CompareTo(Convert.ToInt16(o2));
				else if(column.DataType == Type.GetType(TypeLiterals.SystemUInt32))
						iCompare = Convert.ToUInt32(o1).CompareTo(Convert.ToUInt32(o2));
				else if(column.DataType == Type.GetType(TypeLiterals.SystemUInt16))
						iCompare = Convert.ToUInt16(o1).CompareTo(Convert.ToUInt16(o2));
				else if(column.DataType == Type.GetType(TypeLiterals.SystemInt64))
						iCompare = Convert.ToInt64(o1).CompareTo(Convert.ToInt64(o2));
				else if(column.DataType == Type.GetType(TypeLiterals.SystemDateTime))
						iCompare = Convert.ToDateTime(o1).CompareTo(Convert.ToDateTime(o2));
				else if(column.DataType == Type.GetType(TypeLiterals.SystemDecimal))
						iCompare = Convert.ToDecimal(o1).CompareTo(Convert.ToDecimal(o2));
				else if(column.DataType == Type.GetType(TypeLiterals.SystemSingle))
						iCompare = Convert.ToSingle(o1).CompareTo(Convert.ToSingle(o2));
				else if(column.DataType == Type.GetType(TypeLiterals.SystemChar))
						iCompare = Convert.ToChar(o1).CompareTo(Convert.ToChar(o2));
		 }
			return iCompare;
      }

      protected Object UpdateAggregateMinOrMax(string TableName, string ColumnName, bool bMin, bool ignoreNull)
	  {
		 Object table = dataSourceAccess.GetTableOrView(page, TableName, true, false, false);
		 Object o = null;
		 Object o2;
		 int iCount = GetRowCount(TableName) - GetDeleteCount(TableName, -1);
		 DataColumn column;
		 if( table is DataTable )
			column = (table as DataTable).Columns[ColumnName];
		 else
			column = (table as DataView).Table.Columns[ColumnName];
		 for( int i = 0; i < iCount; i++ )
		 {
			if( ClassUtils.IsDesignTime(page) || (!IsRowDeleted(TableName, i)) )
			{
			   if( table is DataTable )
				  o2 = (table as DataTable).Rows[i][ColumnName];
			   else
				  o2 = (table as DataView)[i].Row[ColumnName];
			   if( o2 == null && ignoreNull )
				  continue;
			   if( o == null )
			   {
				  if( !(o2 is System.DBNull) )
					 o = o2;
			   }
			   else
			   {
				  if( o2 == null || o2 is System.DBNull )
				  {
					if( bMin )
						o = null;
				  }
				  else
				  {
					 int iCompare = ObjectCompare(o, o2, column);
					 if( bMin && iCompare > 0)
						o = o2;
					 else if( !bMin && iCompare < 0 )
						o = o2;
				  }
			   }
			}
		 }
		 return o;
	  }

	  protected Object GetMinForField(string TableName, string ColumnName, bool ignoreNullValues)
	  {
		 string sKey = DBWebConst.sAggregates + fullPageName + TableName + DBWebConst.Splitter + ColumnName +
                       DBWebConst.Splitter + DBWebConst.sAggMin;
         Object o;
         if( !ClassUtils.IsDesignTime(page) )
            o = page.Session[sKey];
         else
            o = null;
         if( o == null )
         {
            o = UpdateAggregateMinOrMax(TableName, ColumnName, true, ignoreNullValues);
            if( !ClassUtils.IsDesignTime(page) )
            {
               RegisterAggKey(sKey);
               page.Session[sKey] = o;
				}
         }
         return o;
      }

	  protected Object GetMaxForField(string TableName, string ColumnName, bool ignoreNullValues)
	  {
		 string sKey = DBWebConst.sAggregates + fullPageName + TableName + DBWebConst.Splitter + ColumnName +
					   DBWebConst.Splitter + DBWebConst.sAggMax;
		 Object o;
		 if( !ClassUtils.IsDesignTime(page) )
			o = page.Session[sKey];
		 else
			o = null;
		 if( o == null )
		 {
			o = UpdateAggregateMinOrMax(TableName, ColumnName, false, ignoreNullValues);
			if( !ClassUtils.IsDesignTime(page) )
			{
				RegisterAggKey(sKey);
				page.Session[sKey] = o;
            }
         }
         return o;
      }

      protected Object GetTotalOrAvgForField(string TableName, string ColumnName, bool getAvg, bool ignoreNulls)
      {
         string sKey;
		 if( getAvg )
			sKey = ClassUtils.GenKeyForAggregate(fullPageName, TableName, ColumnName,
					   ignoreNulls, DBWebConst.sAggAvg);
		 else
				sKey = ClassUtils.GenKeyForAggregate(fullPageName, TableName, ColumnName,
					   ignoreNulls, DBWebConst.sAggTotal);
		 Object o;
		 if( !ClassUtils.IsDesignTime(page) )
			o = page.Session[sKey];
		 else
			o = null;
		 if( o == null )
		 {
			o = UpdateAggregateTotal(TableName, ColumnName, getAvg, ignoreNulls);
			if( !ClassUtils.IsDesignTime(page) )
			{
			   RegisterAggKey(sKey);
			   page.Session[sKey] = o;
			}
		 }
		 return o;
		}

		protected Object AggCount(string TableName, string ColumnName, bool ignoreNullValues)
		{
			int iCount = GetRowCount(TableName) - GetDeleteCount(TableName, -1);
			if( ignoreNullValues )
			{
				Object table = dataSourceAccess.GetTableOrView(page, TableName, true, false, false);
				for( int i = 0; i < iCount; i++ )
				{
					Object o = null;
					if( ClassUtils.IsDesignTime(page) || (!IsRowDeleted(TableName, i)) )
					{
						if( table is DataTable )
							o = (table as DataTable).Rows[i][ColumnName];
						else
							o = (table as DataView)[i].Row[ColumnName];
						if( o == null || (o is System.DBNull) )
							iCount --;
					}
				}
			}
			return iCount;
		}

		public Object GetAggregateValue(string TableName, string ColumnName, AggType aggType, bool ignoreNullValues)
		{
			Object o = null;
			switch(aggType)
			{
				case AggType.aggAvg:
					o = Convert.ToDouble(GetTotalOrAvgForField(TableName, ColumnName, true, ignoreNullValues));
					break;
				case AggType.aggSum:
					o = Convert.ToDouble(GetTotalOrAvgForField(TableName, ColumnName, false, ignoreNullValues));
					break;
				case AggType.aggCount:
					o = AggCount(TableName, ColumnName, ignoreNullValues);
					break;
				case AggType.aggMin:
				   o = GetMinForField(TableName, ColumnName, ignoreNullValues);
				   break;
				case AggType.aggMax:
				   o = GetMaxForField(TableName, ColumnName, ignoreNullValues);
				   break;
			 }
			 return o;
		}
	  #endregion


	  #region handling client requests

	  private bool HasConstraints( DataTable table )
	  {
		for( int i = 0 ; i < table.Columns.Count; i++ )
		 {
			if( table.Columns[i].AllowDBNull == false )
				return true;
		 }
		 return false;
	  }


	   // returns true if row position has changed
	   protected bool HandleClientAction(ClientAction clientAction, int ARowCount,
						string TableName, int ParentRow, int RowToSet)
	   {
		 int currentRow = FCurrentRowHolder;
		 int Direction = 1;
		 bool FRowChanged = false;
		 bool bUndo = false;
		 switch(clientAction)
		 {
			case ClientAction.ecaPrevious:
			   page.Session[fullPageName + TableName + DBWebConst.sLastButtonSelected] = DBWebConst.sPrevText;
			   FCurrentRowHolder -= 1;
			   Direction = -1;
			   FRowChanged = true;
			   break;
			case ClientAction.ecaNext:
			   page.Session[fullPageName + TableName + DBWebConst.sLastButtonSelected] = DBWebConst.sNextText;
			   FCurrentRowHolder += 1;
			   FRowChanged = true;
			   break;
			case ClientAction.ecaFirst:
			   page.Session[fullPageName + TableName + DBWebConst.sLastButtonSelected] = DBWebConst.sFirstText;
			   FCurrentRowHolder = 0;
			   FRowChanged = true;
			   break;
			case ClientAction.ecaLast:
			   page.Session[fullPageName + TableName + DBWebConst.sLastButtonSelected] = DBWebConst.sLastText;
			   Direction = -1;
				FCurrentRowHolder = ARowCount -1;
			   FRowChanged = true;
			   break;
			case ClientAction.ecaUndo:
			   page.Session[fullPageName + TableName + DBWebConst.sLastButtonSelected] = DBWebConst.sUndoText;
			   bUndo = true;
			   break;
			case ClientAction.ecaUndoAll:
			   page.Session[fullPageName + TableName + DBWebConst.sLastButtonSelected] = DBWebConst.sUndoAllText;
			   bUndo = true;
			   break;
			case ClientAction.ecaInsert:
				page.Session[fullPageName + TableName + DBWebConst.sLastButtonSelected] = DBWebConst.sInsertText;
				UpdateApplicationState( TableName, ParentRow );
				if( dataSourceAccess.HasAutoApplyEvent() )
				{  // event not called after insert, so call it before insert.
					dataSourceAccess.DoOnAutoApplyChanges(page);
					SetTablesUpdated(TableName, false);
				}
				UpdateApplicationStateForInsert(ARowCount, TableName);
				FCurrentRowHolder = getCurrentRow(TableName);
				FRowChanged = false;
				page.Session[fullPageName + TableName + DBWebConst.sInsertingRow] = InsertState.InsertStart;
				break;
			case ClientAction.ecaDelete:
			case ClientAction.ecaDeleteRow:
				page.Session[fullPageName + TableName + DBWebConst.sLastButtonSelected] = DBWebConst.sDeleteText;
				if( clientAction == ClientAction.ecaDeleteRow)
					FRowChanged = true;
				// clicked on Delete Linked Column, need to move to that row.
				if( clientAction == ClientAction.ecaDeleteRow )
					FCurrentRowHolder = AddDeletedToRowCount( TableName, RowToSet );
				// else, if clientAction is delete current row, use current row
				UpdateApplicationStateForDelete(FCurrentRowHolder, TableName);
				FCurrentRowHolder = getCurrentRow(TableName);
				break;
			case ClientAction.ecaSetRow:
				FRowChanged = true;
				FCurrentRowHolder = AddDeletedToRowCount( TableName, RowToSet );
				break;
			}
			if( FRowChanged || clientAction == ClientAction.ecaNone)
				UpdateApplicationState( TableName, ParentRow );
			// only 1 navigator control can change rows at a time.  So if parent
			// table has already set new row, it will reset child row to 0.
			// When this happens, the child row must not be set to the current row
			// value retrieved from page's hidden SRowIndex value for that table.
			if( ( dataSource.IndexOfTable(TableName) <= FRowChangeController ) )
			{
				if( FErrors.Count > 0 )	// don't move on to next record if error occurred during update
					ResetCurrentRow(currentRow, TableName, Direction);
				else
					ResetCurrentRow(FCurrentRowHolder, TableName, Direction);
			}
			if( bUndo )  // might alter CurrentRow position
			{
				UpdateApplicationStateForUndo(TableName);
			}
			if( dataSourceAccess.IsDetailTable(TableName) &&
				clientAction != ClientAction.ecaDelete && clientAction != ClientAction.ecaInsert &&
				clientAction != ClientAction.ecaUndo)
			{
				// if Detail table has deleted rows, this can leave the Current
				// Row value at a state greater than the RowCount
				SetRowCount(TableName, GetChildRowCount(TableName) );
			}
			return FRowChanged;
		}

		private ClientAction GetClientAction(NameValueCollection postCollection, string TableName, ref int RowToSet, ref bool bNewRow)
		{
			int FRowCountHolder = Convert.ToInt32(page.Session[fullPageName + TableName + DBWebConst.sRowCount]);
			ClientAction clientAction = ClientAction.ecaNone;
			if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sCancelChange ) ||
					page.Session[DBWebConst.sCancelAll + fullPageName] != null )
				clientAction = ClientAction.ecaCancel;
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sNextText) )
				clientAction = ClientAction.ecaNext;
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sPrevText) )
				clientAction = ClientAction.ecaPrevious;
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sFirstText) )
				clientAction = ClientAction.ecaFirst;
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sLastText) )
				clientAction = ClientAction.ecaLast;
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sApplyText) )
				clientAction = ClientAction.ecaApply;
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sRefreshText) )
				clientAction = ClientAction.ecaRefresh;
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sDeleteText) )
			{  // if the # of undeleted rows is 0, return
				if( FRowCountHolder - GetDeleteCount(TableName, -1) == 0 )
					clientAction = ClientAction.ecaCancel;
				else if( idataSource.HasDetailRecords(page, TableName) &&
					 (dataSource.CascadingDeletes != CascadingDeleteOption.noMasterDelete) )
					clientAction = ClientAction.ecaCancel;
				clientAction = ClientAction.ecaDelete;
			}
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sInsertText) )
			{
				if( FDisallowInsert )
					clientAction = ClientAction.ecaCancel;
				if( dataSource.DataSource is DataView )
				{
					if( !ClassUtils.IsEmpty((dataSource.DataSource as DataView).Sort ))
						clientAction = ClientAction.ecaCancel;
				}
				clientAction = ClientAction.ecaInsert;
				bNewRow = true;
			}
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sUndoText) )
				clientAction = ClientAction.ecaUndo;
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sUndoAllText) )
				clientAction = ClientAction.ecaUndoAll;
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sSetRow ) )
			{
				RowToSet = Convert.ToInt32(postCollection[fullPageName + TableName + DBWebConst.Splitter + DBWebConst.sSetRow]);
				clientAction = ClientAction.ecaSetRow;
			}
			else if( ClassUtils.PostCollectionHasValue(postCollection, fullPageName + TableName, DBWebConst.sDeleteRow ) )
			{
				if( FRowCountHolder - GetDeleteCount(TableName, -1) == 0 )
					clientAction = ClientAction.ecaCancel;
				else if( idataSource.HasDetailRecords(page, TableName) &&
					(dataSource.CascadingDeletes != CascadingDeleteOption.noMasterDelete) )
				clientAction = ClientAction.ecaCancel;
				clientAction = ClientAction.ecaDeleteRow;
				RowToSet = Convert.ToInt32(postCollection[fullPageName + TableName + DBWebConst.Splitter + DBWebConst.sDeleteRow]);
			}
			return clientAction;
	  }

	  private void SetTablesUpdated(string TableName, bool value)
      {
         SetDatasetUpdated(TableName, false);
		   DataRelation relation = dataSourceAccess.GetRelation(page, TableName, "");
         while( relation != null )
         {
            SetDatasetUpdated(relation.ChildTable.TableName, value);
		      relation = dataSourceAccess.GetRelation(page, relation.ChildTable.TableName, "");
         }
		}

		// if client has just inserted a row into a master table,
		// need to make sure that no foreign key values are null.
		// The tableChanges NameValueCollection keeps this information
		private bool CheckForNullForeignKeyValue(string TableName)
		{
			DataColumn[] foreignKeys = dataSource.GetForeignKeys(page, TableName);
			if( foreignKeys != null )
			{
				for( int i = 0; i < foreignKeys.Length; i ++ )
				{
					if( tableChanges[ClassUtils.GenKeyForChangedColumn(fullPageName, TableName, foreignKeys[i].Ordinal)] == null )
                  return true;
            }
         }
         tableChanges.Clear();
         return false;
		}

		private string NextTable(DataSet ds, ArrayList processedTables)
		{
			DataRelation lastRelation = null;
			for( int i = 0; i < ds.Tables.Count; i++ )
			{
				string TableName = ds.Tables[i].TableName;
				if( processedTables.IndexOf(TableName) < 0 )
				{
					DataRelation relation = dataSourceAccess.GetRelation(page, "", TableName);
					while( relation != null )
					{
						if( processedTables.IndexOf(relation.ParentTable.TableName) < 0 )
							TableName = relation.ParentTable.TableName;
						relation = dataSourceAccess.GetRelation(page, "", relation.ParentTable.TableName);
						if( relation == lastRelation )
							break;
						lastRelation = relation;
					}
					processedTables.Add(TableName);
					return TableName;
				}
			}
			return null;
		}

		public void SetChangedValues(NameValueCollection postCollection)
		{
			DataSet dataSet = dataSourceAccess.DataSetFromDataSource(dataSource.DataSource);
			ArrayList processedTables = new ArrayList();
			string ParentTable = null;
			while( processedTables.Count < dataSet.Tables.Count )
			{
				string TableName = NextTable(dataSet, processedTables);
				if( ParentTable == null )
					ParentTable = TableName;
				SetChangedValues(postCollection, TableName);
			}
			if( dataSourceAccess.HasAutoApplyEvent() && !InsertInProgress())
			{  // OnAutoApply should only be once
				dataSourceAccess.DoOnAutoApplyChanges(page);
				SetTablesUpdated(ParentTable, false);
			}
		}

		protected void SetChangedValues(NameValueCollection postCollection, string TableName)
		{
			int SaveRow;
			bool bRowChanged = false;
			bool bNewRow = false;
			int Direction = 1;
			int RowToSet = -1;
			int ParentRow = -1;
			int LastRow = -1;
			int FRowCountHolder = Convert.ToInt32(page.Session[fullPageName + TableName + DBWebConst.sRowCount]);
			FCurrentRowHolder = Convert.ToInt32(page.Session[fullPageName + TableName + DBWebConst.sCurrentRowIndex]);
			SaveRow = FCurrentRowHolder;
			ParentRow = Convert.ToInt32(page.Session[fullPageName + TableName + DBWebConst.sFirstParentRow]);
			LastRow = Convert.ToInt32(page.Session[fullPageName + TableName + DBWebConst.sLastRow]);
			page.Session.Remove(fullPageName + TableName + DBWebConst.sLastButtonSelected);
			if( GetInsertState(TableName) == InsertState.InsertStart )
				SetInsertState(TableName, InsertState.InsertEnd);
			if( LastRow == -1 )
				setLastRow(TableName, FCurrentRowHolder);
			else
				setLastRow(TableName, LastRow);
			postCollectionValues.Clear();
			for(int i = 0; i < postCollection.Count; i++ )
				postCollectionValues.Add(postCollection.GetKey(i), postCollection.Get(i));
			clientAction = GetClientAction(postCollection, TableName, ref RowToSet, ref bNewRow);
			if( clientAction == ClientAction.ecaCancel )
				return;
			else if( clientAction == ClientAction.ecaPrevious ||
						clientAction == ClientAction.ecaLast )
				Direction = -1;
			if( clientAction == ClientAction.ecaNone || clientAction == ClientAction.ecaApply) 
				UpdateApplicationState( TableName, ParentRow );
			else
				bRowChanged = HandleClientAction(clientAction, FRowCountHolder, TableName, ParentRow, RowToSet );
			if( GetInsertState(TableName) == InsertState.InsertEnd && clientAction != ClientAction.ecaDelete && 
                            clientAction != ClientAction.ecaUndo && clientAction != ClientAction.ecaUndoAll)
			{
				if( CheckForNullForeignKeyValue(TableName))
				{
					Exception ex = new Exception(BdwResources.GetString("NoNullForeignKey"));
					HandleException(ex, "", false);
					ResetCurrentRow(SaveRow, TableName, 1);
					clientAction = ClientAction.ecaInsert;
					page.Session[fullPageName + TableName + DBWebConst.sInsertingRow] = InsertState.InsertStart;
					ClearLastError(TableName, false);
					SetInsertState(TableName, InsertState.InsertNone);
					return;
				}
			}
			if( clientAction == ClientAction.ecaApply )
			{
				page.Session[fullPageName + TableName + DBWebConst.sLastButtonSelected] = DBWebConst.sApplyText;
				dataSourceAccess.DoOnApplyChanges(page);
				if( !bRowChanged )
					SetTablesUpdated(TableName, false);
			}
			else if( clientAction == ClientAction.ecaRefresh )
			{
				page.Session[fullPageName + TableName + DBWebConst.sLastButtonSelected] = DBWebConst.sRefreshText;
				dataSourceAccess.DoOnRefresh(page);
				ClearUpdated();
			}
			if( bRowChanged || clientAction == ClientAction.ecaInsert )
			{
				if( clientAction == ClientAction.ecaInsert )
					page.Session[fullPageName + TableName + DBWebConst.sLastButtonSelected] = DBWebConst.sInsertText;
				dataSourceAccess.DoOnScroll(TableName, getCurrentRow(TableName), getLastRow(TableName) );
				AdjustChildCurrentRow(TableName, bNewRow);
				SetTablesUpdated(TableName, false);
				for( int i = 0; i < dataSource.RelatedTables.Count; i++ )
				{
					if( dataSource.RelatedTables[i].ToString() == TableName )
						FRowChangeController = i;
				}
			}
			if( clientAction != ClientAction.ecaInsert )
			{
				page.Session.Remove(fullPageName + TableName + DBWebConst.sInsertingRow);
			}
			if( !dataSourceAccess.IsDetailTable(TableName) )
				SetCurrentObject(dataSourceAccess.GetTableOrView(page, TableName, false, false, false), TableName);
			clientAction = ClientAction.ecaNone;
		}

	  #endregion handling client requests

	  #region DataSet updates

      protected bool UnwritableColumn(string dataType)
      {	// { do not localize and consts here }
			if( dataType.IndexOf(TypeLiterals.SystemByteArray) >= 0  ||
					(dataType.IndexOf(TypeLiterals.SystemTimeSpan) >= 0)  ||
               (dataType.IndexOf("System.Object") >= 0) )
         	return true;
		 return false;
	  }

      protected void UpdateTable(Object table, string Key, string Value)
      {
         ArrayList tables = new ArrayList();
         NameValueCollection changes = new NameValueCollection();
         changes.Add(Key, Value);
         tables.Add(table);
         dataSourceAccess.UpdateTables(page, tables, changes);
      }

	  public bool UpdateChanges(Object table, DataTable TableMetaData, NameValueCollection changedValues, string TableName,
      							int iRow, int iPhysicalRow, bool bImmediateUpdate)
	  {
		string sColumn;
		string sCurrent = null;
		string sNew;
		int iRowCount;
		bool bDataSetChanged = false;
		for( int i = 0; i < changedValues.Count; i++ )
		{
			try
			{
				sColumn = changedValues.GetKey(i);
				if( FDuplicateColumns.IndexOf(sColumn) >= 0 )
				{
				  string sDuplicateColumn = BdwResources.GetString("DuplicateColumn");
				  LogWarning(sColumn + ": " + sDuplicateColumn);
				}
				DataColumn thisColumn = TableMetaData.Columns[sColumn];
				if( thisColumn == null )
					continue;
				string dataType = thisColumn.DataType.ToString();
				if( UnwritableColumn(dataType) )
					continue;
				else if ( !ReadOnlyColumn(thisColumn ) )
				{
					Type DataType = null;
					sCurrent = Convert.ToString(dataSource.GetColumnValue(table, iPhysicalRow, thisColumn.ColumnName, out DataType));
					string sKey = ClassUtils.GenKeyName(fullPageName, DBWebConst.sDbxDelta, TableName, iRow, thisColumn.Ordinal, sCurrent, FCurrentRow);
					sNew = changedValues[sColumn];
					bool bChanged = !ClassUtils.CompareObjects(sCurrent, sNew, dataType);
					if( bChanged || page.Session[sKey] != null )
					{
						if( dataSourceAccess.HasDuplicateKey(page, table, thisColumn, sNew) )
							throw new Exception(BdwResources.GetString("InvalidKey")
															+ " " + sNew + " " + BdwResources.GetString("AlreadyExists")
															+ " " + thisColumn.ColumnName );
						bDataSetChanged = true;
						try
						{
							// this will throw an exception for invalid formats.
							Object o = ClassUtils.ObjectFromString(thisColumn.DataType, sNew);
							if( !ClassUtils.IsEmpty(sNew) )
								tableChanges.Add(ClassUtils.GenKeyForChangedColumn(fullPageName, TableName, thisColumn.Ordinal), sNew);
							if( !bImmediateUpdate )
								SetDatasetUpdated(TableName, false);
							else
								UpdateTable(table, sKey, sNew);
							if( !bChanged )
							{
								while( page.Session[sKey] != null )
									sKey = sKey + "+";
							}
							page.Session[sKey] = changedValues[sColumn];
							RemoveAggKeyForColumn(TableName, thisColumn.ColumnName);
							page.Session[DBWebConst.sLastKeyAdded + fullPageName] = sKey;
						}
						catch( Exception ex )
						{
							HandleException(ex, sKey, false);
							page.Session.Remove(sKey);
						}
					}
				}
			}
			catch( Exception ex1 )
			{
				HandleException(ex1, "", false);
			}
		 }
		 return bDataSetChanged;
	  }

	  protected string FindColumnNameForColumnControl(string postKey, NameValueCollection postCollection, string TableName)
	  {
		 if( postKey == (TableName + DBWebConst.sCurrentRowIndex) ||
				postKey == (TableName + DBWebConst.sRowCount) ||
			   postKey.StartsWith(DBWebDataSource.IdentPrefix + fullPageName) )
			return null;
		 string ColumnName = null;
		 ColumnName = postCollection[DBWebDataSource.IdentPrefix + postKey];
		 if(ColumnName != null)
		 {
			if( ColumnName.StartsWith(TableName + DBWebConst.Splitter) )
				return ColumnName.Substring(ColumnName.IndexOf(DBWebConst.Splitter) + 1);
		 }
		 return null;
	  }

		protected bool ReadOnlyColumn(DataColumn column)
		{
			// if we have just inserted, foreign keys were not readonly and was required
			Object IsKeyColumn = page.Session[ClassUtils.GenKeyForForeignKeyColumn(fullPageName, column.Table.TableName, column.ColumnName)];
			if( (IsKeyColumn != null) && (Convert.ToBoolean(IsKeyColumn) == true) )
				if( GetInsertState(column.Table.TableName) == InsertState.InsertEnd)
					return false;
			return column.ReadOnly;
		}

		// ReadOnly fields and blob fields are ignored
		protected bool GridColumnNotUsed( DataColumn column)
		{
			string sType = column.DataType.ToString();
			return ( ReadOnlyColumn(column) || UnwritableColumn(sType) ||
				 sType.IndexOf(TypeLiterals.SystemCharArray) >= 0 );
		}
		// GetColumnName for persistent Grid Columns.
		//
		protected string FindBoundColumnNameForGrid(string GridId, ref int iGridColumns)
		{	// since each grid is associated with a single table, DataTable and TableName are not needed here
			object o = page.Session[GridId + Convert.ToString(iGridColumns)];
			if( o != null )
			{
				iGridColumns++;
				return o.ToString();
			}
			return null;
		}

//    assuming that the "_ctl#" portion of the postCollection is the last part of the
//        key value, and that it is sufficient to tell the column #.
//        the GridColumnNotUsed() call checks for Blobs and readonly columns;
//        adjust this for blobs, and possibly for user added columns as well.
		protected string FindColumnNameForGrid(DataTable table, string sKey, string TableName, ref int iGridColumns)
      {
         const int MaxColumns = 2000;

         //  Code assumes
         //  1.  GridColumns (ButtonColumn, EditCommandColumn, etc.)
         //  don't show up as submits to postCollection;
         //  2.  _ctrl0 precedes _ctrl1, etc.  However, there is no guarantee
         //  it will start with _ctrl0.  If there are three GridColumns, then
         //  it will start with _ctrl4.  If persistent columns are used,
         //  then FindBoundColumnNameForGrid is called instead.
         // ------------------------------------------------------------------
         //  First, make sure sKey contains grid column
         if( sKey.IndexOf(FAspGridId) > 0 )
         {
         	for( int i = 0; i < MaxColumns; i++ )
            {
               if( sKey.EndsWith(FAspGridId + Convert.ToString(i) ) )
               {
                  // make sure Column is not blob (not in grid) or read-only field
               		while( iGridColumns < table.Columns.Count &&
									GridColumnNotUsed( table.Columns[iGridColumns]) )
                  		iGridColumns++;
                  	iGridColumns++;
                  	if( iGridColumns <= table.Columns.Count )
                    	return table.Columns[iGridColumns-1].ColumnName;
               }
            }
         }
         return null;
      }

      private ArrayList GetGridControls(NameValueCollection postCollection, string TableName)
      {
         ArrayList AList = new ArrayList();
      	for( int i = 0; i < postCollection.Count; i++ )
         {
            string sKey = postCollection.GetKey(i);
            string sValue = postCollection.Get(i).ToString();
			// registered in DBWebGrid.PreRender()
				if( sKey.StartsWith(DBWebConst.sDBWebDataGrid + DBWebConst.Splitter + TableName) )
            	AList.Add(sValue + FAspGridId);
         }
         return AList;
      }

      private bool IsGridColumn(string sKey, ArrayList AList, out string GridID)
      {
         string sCheck;
         GridID = null;
      	for( int i = 0; i < AList.Count; i++ )
         {
            sCheck = AList[i].ToString();
         	if( sKey.StartsWith( sCheck ) )
            {
               GridID = sCheck.Substring(0, sCheck.IndexOf(FAspGridId));
            	return true;
            }
         }
         return false;
      }

      protected int GridColumnCount(string sKey)
      {
         if( ClassUtils.IsDesignTime(page) )
         	return 0;
      	 int EndName = sKey.IndexOf(FAspGridId);
         if( EndName > 0 )
         {
         	string controlName = sKey.Substring(0, EndName);
            object o = page.Session[controlName + FAspGridId];
            if( o != null )
            	return Convert.ToInt32(o) + 1;
         }
         return 0;
      }

      protected int GetPushButtonCount(string sKey, out int iCurrentIndex)
      {
         iCurrentIndex = 0;
         if( ClassUtils.IsDesignTime(page) )
         	return 0;
      	 int EndName = sKey.IndexOf(FAspGridId);
         if( EndName > 0 )
         {
         	string controlName = sKey.Substring(0, EndName);
            object o = page.Session[controlName + DBWebConst.sGridPushButtonCount];
            if( o != null )
            {
                string sIndex = sKey.Substring(sKey.LastIndexOf(DBWebConst.sGridColumnID) +
                                DBWebConst.sGridColumnID.Length);
            	iCurrentIndex = Convert.ToInt32(sIndex);
            	return Convert.ToInt32(o);
            }
         }
			return 0;
      }

      protected bool IsPushButton(string sKey)
      {
        int iIndex;
      	int iPushButtonCount = GetPushButtonCount(sKey, out iIndex);
        if( iIndex < iPushButtonCount )
           return true;
        return false;
      }

//    Web Column controls call register hidden fields to identify the column
// 			associated with the control
//    Grid controls register their ID's so the Grid Column can be identified.
      protected string FindColumnName(DataTable Table, string postKey, string TableName,
                ArrayList GridList, NameValueCollection postCollection, ref int iColumns)
      {
         string sGridId;
         if( IsGridColumn( postKey, GridList, out sGridId) )
         {
            if( postCollection[DBWebConst.sDBWebDataGrid + DBWebConst.Splitter + TableName] != sGridId )
                return null;
            if( iColumns == 0 )
            {
            	object error = page.Session[sGridId + DBWebConst.sInvalidBoundColumns];
                if( error != null && Convert.ToBoolean(error) )
               		throw new Exception(BdwResources.GetString("InvalidGridColumns") + ":" + sGridId);
            }
            if( IsPushButton( postKey ) )
            	return null;
            object o = page.Session[sGridId + DBWebConst.sAutoGenerateColumns];
            if( o == null || Convert.ToBoolean(o) )
					return FindColumnNameForGrid(Table, postKey, TableName, ref iColumns);
            else
            	return FindBoundColumnNameForGrid(sGridId, ref iColumns);
         }
         else
         	return FindColumnNameForColumnControl(postKey, postCollection, TableName);
	  }

		public void ForceUpdate(Object Table, string TableName)
		{
      	ForceUpdate(Table, TableName, false);
      }

      public void ForceUpdate(Object Table, string TableName, bool bImmediateUpdate)
	   {
         string sKey;
		   string sColumnName;
		   DataTable table = null;
		   int iRowCount = 0;
		   if( Table is DataTable )
         {
			   table = Table as DataTable;
			   iRowCount = table.Rows.Count;
		   }
		   else if (Table is DataView )
		   {
			   table = (Table as DataView).Table;
   			iRowCount = (Table as DataView).Count;
         }
         if ( (iRowCount > 0) || 
              ((this.clientAction == ClientAction.ecaInsert) && (iRowCount == 0)) ||
              (GetInsertState(TableName) == InsertState.InsertEnd))
         {
            try
            {
   			   int iRow = getLastRow(TableName);
	   		   // if the last row just been deleted don't try to check for changes
   		   	// in it.
	   		   if( iRow == -1 )
		   		   return;
   		   	int iPhysicalRow = iRow;
   			   if( dataSourceAccess.UsesHardDeletes(page, TableName) )
	   			   iPhysicalRow -= GetDeleteCount(TableName, iRow);
					FDuplicateColumns.Clear();
					NameValueCollection changes = new NameValueCollection();
		   	   int iGridColumns = 0;
   			   ArrayList GridList = GetGridControls(postCollectionValues, TableName);
               for( int i = 0; i < postCollectionValues.Count; i++ )
               {
                  sKey = postCollectionValues.GetKey(i);
                  sColumnName = FindColumnName(table, sKey, TableName, GridList, postCollectionValues, ref iGridColumns);
                  if( sColumnName != null && sColumnName != "" )
                  {
                     if( changes[sColumnName] == null )
								changes.Add( sColumnName, postCollectionValues.Get(i));
							else
							{
								FDuplicateColumns.Add(sColumnName);
								iGridColumns --;
							}
						}
					}
					if( changes.Count > 0 && table != null )
					{
						// pass both the DataTable for metadata and the object (DataView/DataTable)
						if( !bImmediateUpdate )
							bImmediateUpdate = (clientAction == ClientAction.ecaNone) && (IsInsertingRow(TableName));
						if( UpdateChanges(Table, table, changes, TableName, iRow, iPhysicalRow, bImmediateUpdate) )
						{
							if( clientAction == ClientAction.ecaNone && IsInsertingRow(TableName) )
							{
								try
								{
									table.DataSet.EnforceConstraints = true;
								}
								catch(Exception ex)
								{
									HandleException(ex, "", false);
									ClearLastError(TableName, false);
									FDisallowInsert = true;
								}
							}
						}
               }
            }
			   catch(Exception ex)
			   {
				   HandleException(ex, "", false);
			   }
		   }
         return;
      }

	  #endregion DataSet updates

      #region ErrorHandling
      public void HandleException(Exception exp, string UpdateKey, bool bExtended)
      {
         int MinMessageLength = 15;
         if( UpdateKey != "" )
            page.Session.Remove(UpdateKey);
         string sMsg = exp.Message;
         int iStackPos = sMsg.IndexOf(AtSysError);
         if( iStackPos > MinMessageLength )
            sMsg = sMsg.Substring(0, iStackPos -1);
         if( !bExtended && FErrors.IndexOf(sMsg) >= 0 )
            return;
         if( FErrors.IndexOf(sMsg) < 0 )
            FErrors.Add(sMsg);
		   if( bExtended )
		   {
			   DataSet dataSet = dataSourceAccess.DataSetFromDataSource(dataSource.DataSource);
            for( int i = 0; i < dataSet.Tables.Count; i++ )
            {
               DataTable Table = dataSet.Tables[i];
               DataRow[] Errors = Table.GetErrors();
               foreach( DataRow dataRow in Errors )
               {
                  if( dataRow.HasErrors )
                  {
                     int iIndex = 1;
                     System.Data.DataColumn[] ColErrors = dataRow.GetColumnsInError();
                     foreach( DataColumn dataCol in ColErrors )
                     {
                        string sColError = BdwResources.GetString("ErrorInColumn");
                        FErrors.Add(sColError + " " + dataCol.ColumnName + ", " + Table.TableName);
                        iIndex++;
                     }
                  }
               }
            }
         }
      }

      public void LogWarning(string sMsg)
      {
         if( FWarnings.IndexOf(sMsg) < 0 )
            FWarnings.Add(sMsg);
      }
      
	  protected DataTable GetErrorTable(bool bWarnings)
      {
      	DataTable dt = new DataTable();
         string sError;
         if( bWarnings )
         {
	         if( FWarnings.Count > 1 )
   	        sError = BdwResources.GetString("WarningText");
      	   else
         	  sError = BdwResources.GetString("OneWarningText");
         }
         else
		 {
			 if( FErrors.Count > 1 )
   	        sError = BdwResources.GetString("ErrorsText");
      	   else
         	  sError = BdwResources.GetString("OneErrorText");
         }
			dt.Columns.Add(sError, Type.GetType(TypeLiterals.SystemString));

         int iCount;
		 if( bWarnings )
			iCount = FWarnings.Count;
         else
          	iCount = FErrors.Count;
		 for( int i = 0; i < iCount; i++ )
         {
         	DataRow dr = dt.NewRow();
            if( bWarnings )
         		dr[0] = FWarnings[i].ToString();
            else
         		dr[0] = FErrors[i].ToString();
				dt.Rows.Add(dr);
			}
			return dt;
		}

		protected void ClearKey(string sKey, string TableName)
		{
			page.Session.Remove(sKey);
			ResetCurrentRow(0, TableName, 1);
			if( sKey.IndexOf(DBWebConst.sDbxInsert) > 0 )
			{
				string tableName, oldValue;
				int iRow, iCol;
				ClassUtils.GetRowColFromKey(sKey, fullPageName, out tableName, out iRow, out iCol, out oldValue);
				RemoveInsert(sKey, tableName, iRow);
				RemoveAggKeyForColumn(tableName, "");
			}
			SetDatasetUpdated(TableName, false);
		}

		/*  If a change stored in the session have caused an error, it's likely that unless that change is
		    is removed, it will continue causing the same error.  This code detects that an error has 
		    occurred twice in a row, and starts removing the last change until there is no error.  If
		    an AutoApply event is in place, all changes are removed.
		*/
		public bool ClearLastError(string TableName, bool bVerifyInErrorState)
		{
			Object o;
			if( bVerifyInErrorState )
			{
				o = page.Session[fullPageName + TableName + DBWebConst.sErrorState];
				if( o == null )
					return false;
			}
			string sKey = null;
			o = page.Session[DBWebConst.sLastKeyAdded + fullPageName];
			if( o == null )
			{
				for( int i = page.Session.Count - 1; i >= 0; i-- )
				{
					sKey = page.Session.Keys[i];
					if( sKey.StartsWith(DBWebConst.sDbxDelta + fullPageName) )
					{
						ClearKey(sKey, TableName);
						if( !dataSourceAccess.HasAutoApplyEvent() )
							break;
					}
				}
			}
			else
			{
				sKey = o.ToString();
				page.Session[DBWebConst.sLastKeyAdded + fullPageName] = null;
				ClearKey(sKey, TableName);
			}
			return true;
		}

		public string ErrorHtml(string TableName)
		{
			if( FErrors.Count == 0 )
				return "";
			StringWriter sw = new StringWriter();
			HtmlTextWriter tw = new HtmlTextWriter(sw);
			DataGrid errorGrid = new DataGrid();
			errorGrid.ID = "errorGrid";
			errorGrid.DataSource = GetErrorTable(false);
			errorGrid.BorderWidth = dataSource.ErrorDlgBorderWidth;
			errorGrid.BackColor = dataSource.ErrorDlgBackColor;
			errorGrid.ForeColor = dataSource.ErrorDlgForeColor;
			errorGrid.BorderColor = dataSource.ErrorDlgBorderColor;
			errorGrid.DataBind();
			errorGrid.RenderControl(tw);
			Errors.Clear();
			if( !ClearLastError(TableName, true) )
				page.Session[fullPageName + TableName + DBWebConst.sErrorState] = true;
			return sw.ToString() + "<br>";
		}

	  public string WarningsHtml(string TableName)
	  {
			if( FWarnings.Count == 0 )
				return "";
		   StringWriter sw = new StringWriter();
			HtmlTextWriter tw = new HtmlTextWriter(sw);
			DataGrid errorGrid = new DataGrid();
			errorGrid.ID = "errorGrid";
         errorGrid.DataSource = GetErrorTable(true);
         errorGrid.BorderWidth = dataSource.ErrorDlgBorderWidth;
         errorGrid.BackColor = dataSource.ErrorDlgBackColor;
         errorGrid.ForeColor = dataSource.ErrorDlgForeColor;
         errorGrid.BorderColor = dataSource.ErrorDlgBorderColor;
         errorGrid.DataBind();
         errorGrid.RenderControl(tw);
         FWarnings.Clear();
         return sw.ToString() + "<br>";
      }

      #endregion ErrorHandling

 	}
	#endregion PageStateManager

	#region PageStateManagerCollection
   public class PageStateManagerCollection : ArrayList
   {
		public int Add(PageStateManager o)
		{
      	if( base.IndexOf(o) < 0 )
				return base.Add(o);
         return -1;
		}
		public new PageStateManager this[int index]
		{
			get
			{
				return base[index] as PageStateManager;
			}
			set
			{
				base[index] = value as PageStateManager;
			}
		}
      public PageStateManager FindPageStateManager(Page page)
      {
      	for( int i = 0; i < this.Count; i++ )
         	if(this[i].CheckPage(page))
            	return this[i];
         return null;
      }
   }
   #endregion PageStateManagerCollection

}


